within OpenIPSL.Electrical.Loads.PSAT;
model ZIP_ExtInput "PSAT ZIP load with additional input"
  extends OpenIPSL.Electrical.Loads.PSAT.BaseClasses.baseLoad;
  parameter Real Pz=0.33 "Conductance (pu)";
  parameter Real Pi=0.33 "Active current (pu)";
  parameter Real Pp=1 - Pz - Pi "Active power (pu)";
  parameter Real Qz=0.33 "Susceptance (pu)";
  parameter Real Qi=0.33 "Reactive current (pu)";
  parameter Real Qp=1 - Qz - Qi "Reactive power (pu)";
protected
  Real a "Auxiliary variable, voltage division";
public
  Modelica.Blocks.Interfaces.RealInput u annotation (Placement(transformation(
          extent={{48,16},{88,56}}), iconTransformation(extent={{-100,36},{-62,
            74}})));

equation
  a = v/v_0;
  P = P_0/S_b*(Pz*a^2 + Pi*a + Pp) + u;
  Q = Q_0/S_b*(Qz*a^2 + Qi*a + Qp);

  annotation (
    Documentation(info="<html>
<table cellspacing=\"1\" cellpadding=\"1\" border=\"1\">
<tr>
<td><p>Reference</p></td>
<td>PSS/E Manual</td>
</tr>
<tr>
<td><p>Last update</p></td>
<td>Unknown</td>
</tr>
<tr>
<td><p>Author</p></td>
<td><p>Mengjia Zhang,SmarTS Lab, KTH Royal Institute of Technology</p></td>
</tr>
<tr>
<td><p>Contact</p></td>
<td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
</tr>
</table>
</html>"));
end ZIP_ExtInput;
